import json
from pathlib import Path

class PivotParamsError(ValueError):
    pass

def load_pivot_params(path: str | None = None):
    cand = Path(path) if path else Path("pivot_params.json")
    if not cand.exists():
        # also try src/.. default if called from inside src
        cand = Path(__file__).resolve().parent.parent / "pivot_params.json"
    if not cand.exists():
        raise PivotParamsError(f"pivot_params.json not found at: {cand}")
    data = json.loads(Path(cand).read_text(encoding="utf-8"))
    a = float(data["a"]); b = float(data["b"])
    g2 = a*2.0 + b
    if abs(g2 - 1.0) > 1e-6:
        raise PivotParamsError(f"Constraint failed: g(2)={g2} (must equal 1 within 1e-6)")
    if not (a < 0.0):
        raise PivotParamsError(f"Constraint failed: slope a={a} must be < 0")
    return a, b

def g_of_D(D: float, a: float, b: float) -> float:
    return a*D + b
